#!/usr/bin/python

import os
import sys
import struct


class Message:
    def __init__(self, name, fieldNames, fieldFormats):
         self.name = name
         self.fieldNames = fieldNames
         self.fieldFormats = fieldFormats
         self.file = open( os.path.join(outputPath, name+'.csv'), 'w+' )
         fieldNamesOutput = ['timestamp']
         for i in range(len(fieldNames)):
            if fieldFormats[i].find('float[') == 0:
                length = int( fieldFormats[i][ fieldFormats[i].find('[')+1 : -1 ] )
                for j in range(length):
                    fieldNamesOutput.append( fieldNames[i]+'['+str(j)+']' )
            else:
                fieldNamesOutput.append( fieldNames[i] )
         self.file.write( ','.join(fieldNamesOutput)+'\n' )
    def __str__(self):
        string = self.name + '\n';
        for format, value in self.fields.iteritems():
            string += format + ' ' + value + '\n'
        return string

    def parse(self, timestamp, data):
        parsedData = [str(timestamp)]
        # print self.name, self.fieldNames
        # print self.name, self.fieldFormats
        for format in self.fieldFormats:
            if format.find('char[') == 0:
                length = int( format[ format.find('[')+1 : -1 ] )
                parsedData.append( data[:length] )
                data = data[-1:]
                # print 'char[]', length, parsedData

            elif format.find('float[') == 0:
                length = int( format[ format.find('[')+1 : -1 ] )
                for i in range(length):
                    parsedData.append( str(struct.unpack('f', data[:4])[0]) )
                    data = data[4:]
                # print 'float[]', length, parsedData

            elif format == 'int8_t':
                parsedData.append( str(struct.unpack('b', data[:1])[0]) )
                data = data[1:]
                # print 'int8_t', parsedData
            elif format == 'int16_t':
                parsedData.append( str(struct.unpack('h', data[:2])[0]) )
                data = data[2:]
                # print 'int16_t', parsedData
            elif format == 'int32_t':
                parsedData.append( str(struct.unpack('i', data[:4])[0]) )
                data = data[4:]
                # print 'int32_t', parsedData
            elif format == 'int64_t':
                parsedData.append( str(struct.unpack('q', data[:8])[0]) )
                data = data[8:]
                # print 'int32_t', parsedData

            elif format == 'uint8_t':
                parsedData.append( str(struct.unpack('B', data[:1])[0]) )
                data = data[1:]
                # print 'uint8_t', parsedData
            elif format == 'uint16_t':
                parsedData.append( str(struct.unpack('H', data[:2])[0]) )
                data = data[2:]
                # print 'uint16_t', parsedData
            elif format == 'uint32_t':
                parsedData.append( str(struct.unpack('I', data[:4])[0]) )
                data = data[4:]
                # print 'uint32_t', parsedData
            elif format == 'uint64_t':
                parsedData.append( str(struct.unpack('Q', data[:8])[0]) )
                data = data[8:]
                # print 'uint32_t', parsedData

            elif format == 'float':
                parsedData.append( str(struct.unpack('f', data[:4])[0]) )
                data = data[4:]
                # print 'float', parsedData
            elif format == 'double':
                parsedData.append( str(struct.unpack('d', data[:8])[0]) )
                data = data[8:]
                # print 'double', parsedData
        # print self.name, parsedData
        self.file.write( ','.join(parsedData)+'\n' )
    name = ''
    fieldNames = []
    fieldFormats = []
    file

messages = {}


filePath = sys.argv[1]
logFile = open(filePath, 'rb')

fileName, fileExtension = os.path.splitext(filePath)
outputPath = './'+fileName
if not os.path.exists(outputPath):
    os.makedirs( outputPath )


infoFile = open( os.path.join(outputPath, 'info.txt'), 'w+' )
paramsFile = open( os.path.join(outputPath, 'params.txt'), 'w+' )

while 1:
    msgType = logFile.read(1)
    if len(msgType) == 0:
        break
    msgSize = ord( logFile.read(1)[0] )
    if msgType == 'I':
        keyLength = ord( logFile.read(1)[0] )
        key = logFile.read(keyLength)
        key = key[ key.find(']')+2 : ]
        msg = logFile.read(msgSize-1-keyLength)
        infoFile.write( key + ': ' + msg +'\n' );
    if msgType == 'P':
        keyLength = ord( logFile.read(1)[0] )
        key = logFile.read(keyLength)
        msg = logFile.read(msgSize-1-keyLength)
        value = 0
        format = key.split(' ')[0]
        key = key.split(' ')[1]
        if format == 'int8_t':
            value = struct.unpack('b', msg)[0]
        elif format == 'int16_t':
            value = struct.unpack('h', msg)[0]
        elif format == 'int32_t':
            value = struct.unpack('i', msg)[0]

        elif format == 'uint8_t':
            value = struct.unpack('B', msg)[0]
        elif format == 'uint16_t':
            value = struct.unpack('H', msg)[0]
        elif format == 'uint32_t':
            value = struct.unpack('I', msg)[0]

        elif format == 'float':
            value = struct.unpack('f', msg)[0]
        elif format == 'double':
            value = struct.unpack('d', msg)[0]
        paramsFile.write( key + ': ' + str(value) +'\n' );
    if msgType == 'F':
        msgId = ord( logFile.read(1)[0] )
        formatLength = ord( logFile.read(1)[0] )
        msg = logFile.read(formatLength)
        msgSplitted = msg.split(':')
        fieldNames = []
        fieldFormats = []
        for pack in msgSplitted[1].split(';'):
            if pack :
                packSplitted = pack.split(' ')
                fieldNames.append( packSplitted[1] )
                fieldFormats.append( packSplitted[0] )
        messages[ msgId ] = Message( msgSplitted[0], fieldNames, fieldFormats )

    if msgType == 'D':
        msgId = ord( logFile.read(1)[0] )
        multiId = ord( logFile.read(1)[0] )
        timestamp = struct.unpack('Q', logFile.read(8))[0]
        msg = logFile.read(msgSize-10)
        messages[msgId].parse(timestamp/1e6, msg)

print "Export completed!"